//
//  --- Reads the state of 3 switches, sends data to Serial Port & lights an LED
//
//  > Wire 2 LEDs from Digital Pins 6, 7 (pins 12, 13 on the chip) thru 330 ohm resistors to ground
//  > Wire 3 switches between Digital Pins 2, 3, 4  (pins 4, 5, 6 on the chip) and ground
//

// assign variables to pins
int button1Pin = 2;
int button2Pin = 3;
int button3Pin = 4;

int led1Pin = 6;
int led2Pin = 7;

// create variables for storing "state" of the buttons
int button1State = 0;
int button2State = 0;
int button3State = 0;

void setup() {                        // only do once at startup
  pinMode(led1Pin, OUTPUT);           // initialize the digital pins as outputs (for LEDs)
  pinMode(led2Pin, OUTPUT);
  pinMode(button1Pin, INPUT_PULLUP);  // initialize the digital pins as inputs (for switches)
  pinMode(button2Pin, INPUT_PULLUP);
  pinMode(button3Pin, INPUT_PULLUP);
  Serial.begin(9600);                 // initialize serial port
}

void loop() {                              // repeat forever
  button1State = digitalRead(button1Pin);  // "read" the voltage present on the pins (check switches)
  button2State = digitalRead(button2Pin);
  button3State = digitalRead(button3Pin);
  delay(20);                               // let switches stop bouncing

  // If the pin wired to the button is low, the switch is closed
  if (button1State == LOW) {
    Serial.write(1);              // send data to serial port as BYTE
    digitalWrite(led1Pin, HIGH);  // turn on LED
    delay(20);                    // wait just a bit
  } else {                        // otherwise
    digitalWrite(led1Pin, LOW);   // turn off lED
  }
  if (button2State == LOW) {
    Serial.write(2);
    digitalWrite(led1Pin, HIGH);
    delay(20);
  } else {
    digitalWrite(led1Pin, LOW);
  }
  if (button3State == LOW) {
    Serial.write(3);
    digitalWrite(led1Pin, HIGH);
    delay(20);
  } else {
    digitalWrite(led1Pin, LOW);
  }
}

